/***************************************************
*  VIV.c
*
*
*   VIC initialization
*	- Timer priority 0 (highest)
*	- UART1 priority 1
*
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.
*
*****************************************************/

#include "LPC17xx.h"


void VIC_init (void)  
{
	NVIC_SetPriorityGrouping( 4 ); 		//sets PRIGROUP to 8 groups 4 sub priorities	
	NVIC_SetPriority( TIMER0_IRQn, 0 );	//000:00 (bit 7:3) assign GPIO int to group 0, sub-priority 0 within group 0
	NVIC_SetPriority( UART1_IRQn, 4 ); //001:00 (bit 7:3) assign GPIO int to group 1, sub-priority 0 within group 1
	NVIC_EnableIRQ( TIMER0_IRQn );
	NVIC_EnableIRQ( UART1_IRQn );
}



